#include "AD18F08.h"
#include "common.h"

/*******************************************************************************
// ----Function: GPIO_Init
// --Parameters: 
// -----Returns: None   
//---------Note:所有IO初始化
*******************************************************************************/

void GPIO_Init(void)
{
	TRISA = 0X00;   //PA输出模式
	TRISB = 0X00;   //PB输出模式
	
	PORTA = 0X00;	//PORTA输出0
	PORTB = 0X00;	//PORTB输出0
	
	PAPD = 0XFF;    //关闭PA下拉
	PAPU = 0XFF;    //关闭PA上拉
	PBPD = 0XFF;    //关闭PB下拉
	PBPU = 0XFF;    //关闭PB上拉
	
	PAOD = 0X00;    //关PA开漏输出
	PBOD = 0X00;    //关PB开漏输出
	
	ANASEL0 = 0X00; //关PA模拟量通道
	ANASEL1 = 0X00; //关PB模拟量通道
}



void Timer3_PWM(void)
{
	PWM2CON0 = 0X0F;  //使能pwm2~4功能
	PWM2CON1 = 0X00;  //正向输出
	PWM2CON3 = 0X00;

	PWM1CON0 = 0X00;   //无保护
	PMS = 0X80;   //互补式控制
	PXC = 0X80;   //使能pwm映射 2>0 3>1 4>2
	DTC = 0XAA;   //死区        2.3us
	POLS = 0X00;  //同相输出
	PME = 0XFF;   //使能映射    01>PB1  00>PB2
	PCS = 0X0F;   // PB2、PB1、PB4、PA3、PB6、PB7

	PR3H = 0X07;
	PR3L = 0XD0;
	TMR3H = 0X00;
	TMR3L = 0X00;
	T3CON = 0X07;  ////使能timer3   16分频
}


/*******************************************************************************
* Description    : Timer3_PWM5占空比设置
* Input          : Timer3_PWM5的占空比  
* Return         : None.
* Note           : 该函数可以设置Timer1_PWM的占空比
*                  *占空比=[PR3H:PR3L]*(Duty/100)
*******************************************************************************/
void T3_PWM5_Duty(unsigned short Duty)
{   
   unsigned char PWMH = 0;
   unsigned char PWML = 0;
   
   Duty     = Duty-1;
   PWMH     = (Duty >> 8) & 0xFF;
   PWML     = Duty & 0xFF;

   PWM5H    = PWMH; 
   PWM5L    = PWML;   //设置PWM占空比
}

/*******************************************************************************
* Description    : Timer3_PWM4占空比设置
* Input          : Timer3_PWM4的占空比  
* Return         : None.
* Note           : 该函数可以设置Timer1_PWM的占空比
*                  *占空比=[PR3H:PR3L]*(Duty/100)
*******************************************************************************/
void T3_PWM4_Duty(unsigned short Duty)
{   
   unsigned char PWMH = 0;
   unsigned char PWML = 0;
   
   Duty     = Duty-1;
   PWMH     = (Duty >> 8) & 0xFF;
   PWML     = Duty & 0xFF;

   PWM4H    = PWMH; 
   PWM4L    = PWML;   //设置PWM占空比
}

/*******************************************************************************
* Description    : Timer3_PWM3占空比设置
* Input          : Timer3_PWM3的占空比  
* Return         : None.
* Note           : 该函数可以设置Timer1_PWM的占空比
*                  *占空比=[PR3H:PR3L]*(Duty/100)
*******************************************************************************/
void T3_PWM3_Duty(unsigned short Duty)
{   
   unsigned char PWMH = 0;
   unsigned char PWML = 0;
   
   Duty     = Duty-1;
   PWMH     = (Duty >> 8) & 0xFF;
   PWML     = Duty & 0xFF;
   
   PWM3H    = PWMH; 
   PWM3L    = PWML;   //设置PWM占空比
}

/*******************************************************************************
* Description    : Timer3_PWM2占空比设置
* Input          : Timer3_PWM2的占空比  
* Return         : None.
* Note           : 该函数可以设置Timer1_PWM的占空比
*                  *占空比=[PR3H:PR3L]*(Duty/100)
*******************************************************************************/
void T3_PWM2_Duty(unsigned short Duty)
{   
   unsigned char PWMH = 0;
   unsigned char PWML = 0;
   
   Duty     = Duty-1;
   PWMH     = (Duty >> 8) & 0xFF;
   PWML     = Duty & 0xFF;

   PWM2H    = PWMH; 
   PWM2L    = PWML;   //设置PWM占空比
}